// ======== ======== ======== ======== ======== ======== ======== ========
//
//	title : classMake[ sceneSkyDome.cpp ]		Auter : KENSUKE WATANABE
//														Data  : 2017/04/27
//
// -------- -------- -------- -------- -------- -------- -------- --------
//Update : 2017/04/27
//
// ======== ======== ======== ======== ======== ======== ======== ========
// -------- -------- -------- -------- -------- -------- -------- --------
// CN[ht@C
// -------- -------- -------- -------- -------- -------- -------- --------
#include <math.h>
#include "main.h"
#include "scene3D.h"
#include "sceneCylinder.h"
#include "input.h"
#include "manager.h"
#include "texManager.h"
#include "renderer.h"

// ======== ======== ======== ======== ======== ======== ======== ========
// 
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneCylinder::Init( void )
{
	// 
	SetPos(D3DXVECTOR3(0.f, 0.f, 0.f));
	SetRot(D3DXVECTOR3(0.f, 0.f, 0.f));
	SetScl(D3DXVECTOR3(1.f, 1.f, 1.f));
	SetSize(D3DXVECTOR3(1.f, 1.f, 1.f));
	m_move = D3DXVECTOR3(0.f, 0.f, 0.f);
	m_strFilePass.clear();
}

//-----------------------------------------------------------------------------
// I
//-----------------------------------------------------------------------------
void CSceneCylinder::Uninit( void )
{
	// CfbNXobt@̉
	if(m_pIdxBuffer != nullptr)
	{
		m_pIdxBuffer->Release();
		m_pIdxBuffer = nullptr;
	}

	// eNX̏I
	CScene3D::Uninit();
}

// ======== ======== ======== ======== ======== ======== ======== ========
// XV
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneCylinder::Update( void )
{

}

// ======== ======== ======== ======== ======== ======== ======== ========
// |S`
// -------- -------- -------- -------- -------- -------- -------- --------
void CSceneCylinder::Draw( void )
{
	// foCX̎擾
	LPDIRECT3DDEVICE9 pDevice = CRenderer::GetDevice();

	D3DXVECTOR3 pos = GetPos();
	D3DXVECTOR3 rot = GetRot();
	D3DXVECTOR3 scl = GetScl();

	// [h}gNX̍쐬
	D3DXMATRIX mtxScl;						// gs
	D3DXMATRIX mtxRot;						// ]s
	D3DXMATRIX mtxPos;						// ss

	D3DXMatrixIdentity(&m_mtxWorld);		// sPʍsɂ( g嗦1,0ŏ )
	D3DXMatrixIdentity(&mtxScl);			// 
	D3DXMatrixIdentity(&mtxRot);			// 
	D3DXMatrixIdentity(&mtxPos);			// 

	// [hϊsݒ肵ĕϊ
	D3DXMatrixScaling(&mtxScl, scl.x, scl.y, scl.z);				// gs
	D3DXMatrixRotationYawPitchRoll(&mtxRot, rot.y, rot.x, rot.z);	// ]s
	D3DXMatrixTranslation(&mtxPos, pos.x, pos.y, pos.z);			// ss

	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxScl);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxRot);
	D3DXMatrixMultiply(&m_mtxWorld, &m_mtxWorld, &mtxPos);

	// foCXɃ[hϊsݒ
	pDevice->SetTransform(D3DTS_WORLD, &m_mtxWorld);

	// _tH[}bg̐ݒ
	pDevice->SetFVF(FVF_VERTEX_3D);

	// CfbNXԍfoCXɐݒ
	pDevice->SetIndices(m_pIdxBuffer);

	// eNX`pCvCɃZbg
	if(!m_strFilePass.empty())
	{
		pDevice->SetTexture(0, CManager::GetTexManager()->GetTexInterface(m_strFilePass));
	}else {pDevice->SetTexture(0, nullptr);}

	// _obt@foCX̃f[^ Xg[ɃoCh
	pDevice->SetStreamSource(0, m_pVtxBuffer, 0, sizeof(VERTEX_3D));

	pDevice->DrawIndexedPrimitive(D3DPT_TRIANGLESTRIP, 0, 0, NUM_POLYGON, 0, GetNumIndex() - 2);
}

//-----------------------------------------------------------------------------
// _쐬
//-----------------------------------------------------------------------------
HRESULT CSceneCylinder::SetVtx(LPDIRECT3DDEVICE9 pDevice, int stacks, int slices)
{
	float phi =	(D3DX_PI * 2) / stacks;			// Ƃ̊px

	m_slices = slices;
	m_stacks = stacks;

	int numVtx = ((slices + 1) * (stacks + 1));						// _
	int numIndex = ((stacks + 1) * 2 * slices) + (slices - 1) * 2;	// CfbNX(Op` + ѕ(kރ|S))
	SetNumVtx(numVtx);
	SetNumIndex(numIndex);

	// _obt@쐬--------------------------------
	if(FAILED(pDevice->CreateVertexBuffer(sizeof(VERTEX_3D) * numVtx,
		D3DUSAGE_WRITEONLY, FVF_VERTEX_3D, D3DPOOL_MANAGED, &m_pVtxBuffer, nullptr)))
	{
		return E_FAIL;
	}
	VERTEX_3D* pVtx;	// obt@bN
	m_pVtxBuffer->Lock(0, 0, (void**)&pVtx, 0);

	// 1ubN̕ƍ
	D3DXVECTOR3 size = GetSize();

	// _̐ݒ
	float x, y, z;

	for(int cntSlices = 0; cntSlices <= slices; cntSlices++)
	{
		for(int cntStacks = 0; cntStacks <= stacks; cntStacks++)
		{
			// W
			x = cos(phi * cntStacks) * size.x,			// X
			y = (float)slices - cntSlices * size.y,		// Y
			z = sin(phi * cntStacks) * size.z;			// Z
			pVtx[0].pos = D3DXVECTOR3(x, y, z);
			// @
			pVtx[0].nom = D3DXVECTOR3(0.f, 1.f, 0.f);
			// F
			pVtx[0].col = D3DCOLOR_RGBA(255, 255, 255, 255);
			// eNX`W
			pVtx[0].tex = D3DXVECTOR2((1.f / stacks) * cntStacks, (1.f / slices) * cntSlices);
			pVtx++;
		}
	}
	// bN̉
	m_pVtxBuffer->Unlock();

	// CfbNXobt@쐬--------------------------------
	if(FAILED(pDevice->CreateIndexBuffer(
		sizeof(WORD) * numIndex,			// obt@
		D3DUSAGE_WRITEONLY,					// gptO
		D3DFMT_INDEX16,						// Kvȃobt@
		D3DPOOL_MANAGED,					// ̊Ǘ@
		&m_pIdxBuffer,
		nullptr)))
	{
		return E_FAIL;
	}

	WORD *pIdx;			// obt@bN
	m_pIdxBuffer->Lock(0, 0, (void**)&pIdx, 0);

	int nCnt = 0;
	for (int nCntY = 0; nCntY < slices; nCntY++)
	{
		if (nCntY != 0)	// ԏ߂Ȃ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY + (stacks + 1));
			nCnt++;
		}
		// 2_ł(㉺)
		pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY);
		nCnt++;
		pIdx[nCnt] = static_cast<WORD>((stacks + 1) * (nCntY + 1));
		nCnt++;

		for (int nCntX = 0; nCntX < stacks; nCntX++)
		{
			// 2_ł(㉺)
			pIdx[nCnt] = static_cast<WORD>((stacks + 1) * nCntY + (nCntX + 1));
			nCnt++;
			pIdx[nCnt] = static_cast<WORD>(((stacks + 1) * (nCntY + 1)) + (nCntX + 1));
			nCnt++;
		}
		if (nCntY != slices - 1)	// ŌザȂ
		{
			// _ł
			pIdx[nCnt] = static_cast<WORD>(stacks + (nCntY * (stacks + 1)));
			nCnt++;
		}
	}

	//bN̉
	m_pIdxBuffer->Unlock();

	return NOERROR;
}

// -------- -------- -------- -------- -------- -------- -------- --------
// 쐬
// -------- -------- -------- -------- -------- -------- -------- --------
CSceneCylinder *CSceneCylinder::Create(const D3DXVECTOR3 &pos, const D3DXVECTOR3 &rot, const D3DXVECTOR3 &size, const std::string &strFilePass)
{
	// CSceneCylinder̐
	CSceneCylinder *pSceneCylinder;
	pSceneCylinder = new CSceneCylinder();
	pSceneCylinder->Init();

	pSceneCylinder->SetPos(pos);
	pSceneCylinder->SetRot(rot);
	pSceneCylinder->SetSize(size);
	pSceneCylinder->m_strFilePass = strFilePass;

	// _ݒ菈
	pSceneCylinder->SetVtx(CRenderer::GetDevice(), 32, 1);
	
	// eNX`̃Zbg
	CManager::GetTexManager()->SetTex(strFilePass);

	return pSceneCylinder;
}